/*
 *  KernelEx
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2015, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _NTDLL_APILIST_H
#define _NTDLL_APILIST_H

#include "ntstatus.h"
#define WIN32_NO_STATUS
#include "kexcoresdk.h"
#include <ntsecapi.h>

typedef enum _SHUTDOWN_ACTION {
    ShutdownNoReboot, ShutdownReboot, ShutdownPowerOff
} SHUTDOWN_ACTION, *PSHUTDOWN_ACTION;

typedef struct _CLIENT_ID {
  DWORD UniqueProcessId;
  DWORD UniqueThreadId;
} CLIENT_ID, *PCLIENT_ID;

#define ANSI_STRING STRING
#define PANSI_STRING PSTRING
#define POEM_STRING PSTRING
#define PCOEM_STRING PSTRING
#define PCSZ PCSTR

//#define PRTL_BITMAP PVOID
typedef struct _TRL_BITMAP {
  ULONG SizeOfBitMap;
  ULONG *Buffer;
} RTL_BITMAP, *PRTL_BITMAP;


#define NT_SUCCESS 0

BOOL init_ntdll();
extern const apilib_api_table apitable_ntdll;

/*** AUTOGENERATED APILIST DECLARATIONS BEGIN ***/

// ntdll\Dbg.c
NTSTATUS DbgPrint_stub (char *pFormat, ...);
NTSTATUS DbgPrint_dbg (char *pFormat, ...);
NTSTATUS DbgPrintEx_stub (UINT uId, UINT uLevel, char *pFormat, ...);
NTSTATUS DbgPrintEx_dbg (UINT uId, UINT uLevel, char *pFormat, ...);
NTSTATUS vDbgPrintEx_stub (UINT uId, UINT uLevel, char *pFormat, va_list ap);
NTSTATUS vDbgPrintEx_dbg (UINT uId, UINT uLevel, char *pFormat, va_list ap);
NTSTATUS vDbgPrintExWithPrefix_stub (char *pPrefix, UINT uId, UINT uLevel, char *pFormat, va_list ap);
NTSTATUS vDbgPrintExWithPrefix_dbg (char *pPrefix, UINT uId, UINT uLevel, char *pFormat, va_list ap);
void DbgBreakPoint_stub (char *pCondition, char *pFileName, int iLine);
void DbgBreakPoint_dbg (char *pCondition, char *pFileName, int iLine);
UINT DbgPrompt_stub (char *pPrompt, char *pResponse, UINT uLength);
UINT DbgPrompt_dbg (char *pPrompt, char *pResponse, UINT uLength);

// ntdll\Nt.c
NTSTATUS WINAPI NtClose_new (HANDLE h);
NTSTATUS NtQuerySystemTime_new (PLARGE_INTEGER SystemTime);
NTSTATUS NtQueryPerformanceCounter_new (PLARGE_INTEGER pPerfCount, PLARGE_INTEGER pPerfFreq);
NTSTATUS NTAPI NtShutdownSystem_new (SHUTDOWN_ACTION Action);
ULONG RtlUniform_new (IN PULONG Seed);
NTSTATUS NTAPI NtAllocateVirtualMemory_new (HANDLE ProcessHandle, PVOID *UBaseAddress, ULONG_PTR ZeroBits, PSIZE_T RegionSize, ULONG AllocationType, ULONG Protect);
NTSTATUS NTAPI NtWaitForSingleObject_new (HANDLE hObject, BOOLEAN Alertable, PLARGE_INTEGER TimeOut);

// ntdll\RtlString.c
NTSTATUS RtlMultiByteToUnicodeSize_new (PULONG puSize, PCSTR pMbStr, ULONG cbMbSize);
DWORD RtlAnsiStringToUnicodeSize_new (PSTRING psIn);
DWORD RtlOemStringToUnicodeSize_new (PSTRING psIn);
NTSTATUS RtlUnicodeToMultiByteSize_new (PULONG pMbSize, PWCH pWcStr, ULONG WcSize);
ULONG RtlUnicodeStringToASize_new (PUNICODE_STRING pusIn);
NTSTATUS RtlMultiByteToUnicodeN_new (PWCHAR pWide, ULONG cbWideMax, PULONG pcbWide, PCSTR pMbStr, ULONG MbSize);
NTSTATUS RtlOemToUnicodeN_new(PWCHAR pWide, ULONG cbWideMax, PULONG pcbWide, PCCH pOem, ULONG cbOem);
NTSTATUS RtlUnicodeToMultiByteN_new(PSTR pMbStr, ULONG MbMaxSize, PULONG pMbSize, PWCH pUnicodeStr, ULONG UnicodeSize);
PWCHAR RtlpAllocateMemory_new (UINT cbLen, UINT tag);
NTSTATUS RtlAnsiStringToUnicodeString_fix(PUNICODE_STRING pusOut, PSTRING pasIn, BOOLEAN bAllocate);
NTSTATUS RtlOemStringToUnicodeString_new(PUNICODE_STRING pusOut, POEM_STRING posIn, BOOLEAN bAllocate);
NTSTATUS RtlUnicodeStringToAnsiString_fix (PANSI_STRING pasOut, PUNICODE_STRING pusIn, BOOLEAN bAllocate);
NTSTATUS RtlUnicodeStringToOemString_new (POEM_STRING posOut, PUNICODE_STRING pusIn, BOOLEAN bAllocate);
NTSTATUS RtlUpcaseUnicodeString_new(PUNICODE_STRING pusOut, PUNICODE_STRING pusIn, BOOLEAN bAllocate);
BOOLEAN RtlCreateUnicodeString_new (PUNICODE_STRING pusOut, PCWSTR wszIn);
BOOLEAN RtlCreateUnicodeStringFromAsciiz_new(PUNICODE_STRING pusOut, PCSZ szIn);
LONG RtlCompareUnicodeString_new(IN PUNICODE_STRING String1, IN PUNICODE_STRING String2, IN BOOLEAN CaseInsensitive);
BOOLEAN RtlEqualUnicodeString_new(IN CONST PUNICODE_STRING String1, IN CONST PUNICODE_STRING String2, IN BOOLEAN CaseInsensitive);
NTSTATUS RtlExpandEnvironmentStrings_U_new(IN PWSTR Environment, IN PUNICODE_STRING pusSource, OUT PUNICODE_STRING pusDestination, OUT PULONG Length);
VOID RtlFreeString_new (PSTRING pString);
VOID RtlInitString_new(IN OUT PSTRING pString, IN PCSZ szSource);
NTSTATUS RtlInitStringEx_new(IN OUT PSTRING pString, IN PCSZ szSource);
VOID RtlInitUnicodeString_new(IN OUT PUNICODE_STRING pString, IN PWSTR wszSource);
NTSTATUS RtlInitUnicodeStringEx_new(IN OUT PUNICODE_STRING pString, IN PWSTR wszSource);
BOOLEAN RtlPrefixUnicodeString_new(PUNICODE_STRING String1, PUNICODE_STRING String2, BOOLEAN CaseInsensitive);
WCHAR RtlUpcaseUnicodeChar_new (IN WCHAR Source);
VOID RtlCopyUnicodeString_new (PUNICODE_STRING pusDest, PUNICODE_STRING pusSrc);
NTSTATUS RtlDuplicateUnicodeString_new (UINT Flags, PUNICODE_STRING pusSrc, PUNICODE_STRING pusDest);
VOID RtlRunDecodeUnicodeString_new (UCHAR hash, PUNICODE_STRING pus);
VOID RtlRunEncodeUnicodeString_new (PUCHAR phash, PUNICODE_STRING pus);

// ntdll\_ntdll_apilist.c

// ntdll\_ntdll_stubs.c
STUB CsrGetProcessId_stub;
STUB NtOpenFile_stub;
STUB NtQueryInformationProcess_stub;
STUB NtQueryInformationThread_stub;
STUB NtQuerySystemInformation_stub;
STUB NtSetInformationProcess_stub;
STUB NtDeviceIoControlFile_stub;
STUB RtlAddAccessAllowedAceEx_stub;
STUB RtlAddAccessDeniedAceEx_stub;
STUB RtlCharToInteger_stub;
STUB RtlCompareMemory_stub;
STUB RtlDeleteResource_stub;
STUB RtlInitializeResource_stub;
STUB LdrLoadDll_stub;
STUB LdrUnloadDll_stub;
STUB NtQueryAttributesFile_stub;
STUB NtQueryDirectoryFile_stub;
STUB NtQueryInformationFile_stub;
STUB NtAcceptConnectPort_stub;
STUB NtCompleteConnectPort_stub;
STUB NtConnectPort_stub;
STUB NtCreatePort_stub;
STUB NtListenPort_stub;
STUB NtCreateEvent_stub;
STUB NtCreateIoCompletion_stub;
STUB NtCreateKey_stub;
STUB NtCreateNamedPipeFile_stub;
STUB NtCreateSection_stub;
STUB RtlAcquireResourceExclusive_stub;
STUB RtlAcquireResourceShared_stub;
STUB RtlReleaseResource_stub;
STUB RtlpEnsureBufferSize_stub;
STUB LdrAccessResource_stub;
STUB LdrFindResource_U_stub;
STUB RtlAppendUnicodeStringToString_stub;
STUB RtlAppendUnicodeToString_stub;
STUB RtlConvertSidToUnicodeString_stub;
STUB RtlGetNtProductType_stub;
STUB RtlGUIDFromString_stub;
STUB RtlIpv4StringToAddressW_stub;
STUB RtlUpcaseUnicodeToMultiByteN_stub;
STUB RtlAssert_stub;
STUB NtCreateProfile_stub;
STUB NtCreateProfileEx_stub;
STUB NtSetIntervalProfile_stub;
STUB NtStartProfile_stub;
STUB NtStopProfile_stub;
STUB NtQueryIntervalProfile_stub;
STUB NtFsControlFile_stub;
STUB NtOpenKey_stub;
STUB NtQueryOpenSubKeys_stub;
STUB NtSetValueKey_stub;
STUB RtlDestroyEnvironment_stub;
STUB RtlQueryEnvironmentVariable_U_stub;
STUB RtlSetEnvironmentVariable_stub;
STUB RtlUnicodeStringToInteger_stub;
STUB NtEnumerateValueKey_stub;
STUB NtQueryKey_stub;
STUB NtQueryValueKey_stub;
STUB NtMapViewOfSection_stub;
STUB NtUnmapViewOfSection_stub;
STUB RtlDosPathNameToNtPathName_U_stub;
STUB RtlGetHandleValueHeap_stub;
STUB RtlGrowHeap_stub;
STUB RtlSetHandleValueHeap_stub;
STUB RtlAddAccessDeniedAce_stub;
STUB RtlAddAce_stub;
STUB RtlAddAuditAccessAce_stub;
STUB RtlDeleteSecurityObject_stub;
STUB RtlFirstFreeAce_stub;
STUB RtlNewSecurityObject_stub;
STUB RtlQueryInformationAcl_stub;
STUB RtlQuerySecurityObject_stub;
STUB RtlSetControlSecurityDescriptor_stub;
STUB RtlSetInformationAcl_stub;
STUB RtlSetSaclSecurityDescriptor_stub;
STUB RtlSetSecurityObject_stub;
STUB RtlValidAcl_stub;
STUB RtlIsCriticalSectionLocked_stub;
STUB RtlIsCriticalSectionLockedByThread_stub;

// ntdll\_ntdll_undoc_stubs.c
STUB KiUserApcDispatcher_stub;
STUB NtAlertThread_stub;
STUB NtQueueApcThread_stub;
STUB NtTestAlert_stub;
STUB NtAddAtom_stub;
STUB NtDeleteAtom_stub;
STUB NtFindAtom_stub;
STUB NtQueryInformationAtom_stub;
STUB RtlCompressBuffer_stub;
STUB RtlDecompressBuffer_stub;
STUB RtlGetCompressionWorkSpaceSize_stub;
STUB NtDisplayString_stub;
STUB NtRaiseException_stub;
STUB NtRaiseHardError_stub;
STUB NtSetDefaultHardErrorPort_stub;
STUB NtQuerySystemEnvironmentValue_stub;
STUB NtSetSystemEnvironmentValue_stub;
STUB RtlCreateEnvironment_stub;
STUB RtlSetCurrentEnvironment_stub;
STUB LdrGetDllHandle_stub;
STUB LdrGetProcedureAddress_stub;
STUB LdrQueryProcessModuleInformation_stub;
STUB LdrShutdownProcess_stub;
STUB LdrShutdownThread_stub;
STUB NtLoadDriver_stub;
STUB NtUnloadDriver_stub;
STUB NtQueryDefaultLocale_stub;
STUB NtSetDefaultLocale_stub;
STUB RtlAllocateHeap_stub;
STUB RtlCompactHeap_stub;
STUB RtlCreateHeap_stub;
STUB RtlDestroyHeap_stub;
STUB RtlEnumProcessHeaps_stub;
STUB RtlFreeHeap_stub;
STUB RtlGetProcessHeaps_stub;
STUB RtlLockHeap_stub;
STUB RtlProtectHeap_stub;
STUB RtlReAllocateHeap_stub;
STUB RtlSizeHeap_stub;
STUB RtlUnlockHeap_stub;
STUB RtlValidateHeap_stub;
STUB RtlValidateProcessHeaps_stub;
STUB RtlWalkHeap_stub;
STUB NtFlushVirtualMemory_stub;
STUB NtFreeVirtualMemory_stub;
STUB NtLockVirtualMemory_stub;
STUB NtProtectVirtualMemory_stub;
STUB NtQueryVirtualMemory_stub;
STUB NtReadVirtualMemory_stub;
STUB NtUnlockVirtualMemory_stub;
STUB NtWriteVirtualMemory_stub;
STUB NtDuplicateObject_stub;
STUB NtMakeTemporaryObject_stub;
STUB NtQueryObject_stub;
STUB NtSetInformationObject_stub;
STUB NtSignalAndWaitForSingleObject_stub;
STUB NtWaitForMultipleObjects_stub;
STUB NtCreateDirectoryObject_stub;
STUB NtOpenDirectoryObject_stub;
STUB NtQueryDirectoryObject_stub;
STUB NtClearEvent_stub;
STUB NtOpenEvent_stub;
STUB NtPulseEvent_stub;
STUB NtQueryEvent_stub;
STUB NtResetEvent_stub;
STUB NtSetEvent_stub;
STUB NtCreateEventPair_stub;
STUB NtOpenEventPair_stub;
STUB NtSetHighEventPair_stub;
STUB NtSetHighWaitLowEventPair_stub;
STUB NtSetLowEventPair_stub;
STUB NtSetLowWaitHighEventPair_stub;
STUB NtWaitHighEventPair_stub;
STUB NtWaitLowEventPair_stub;
STUB NtSetHighWaitLowThread_stub;
STUB NtSetLowWaitHighThread_stub;
STUB NtCancelIoFile_stub;
STUB NtCreateMailslotFile_stub;
STUB NtCreatePagingFile_stub;
STUB NtDeleteFile_stub;
STUB NtFlushBuffersFile_stub;
STUB NtLockFile_stub;
STUB NtNotifyChangeDirectoryFile_stub;
STUB NtQueryEaFile_stub;
STUB NtQueryFullAttributesFile_stub;
STUB NtQueryOleDirectoryFile_stub;
STUB NtQueryVolumeInformationFile_stub;
STUB NtReadFile_stub;
STUB NtReadFileScatter_stub;
STUB NtSetEaFile_stub;
STUB NtSetInformationFile_stub;
STUB NtSetVolumeInformationFile_stub;
STUB NtUnlockFile_stub;
STUB NtWriteFile_stub;
STUB NtWriteFileGather_stub;
STUB NtOpenIoCompletion_stub;
STUB NtQueryIoCompletion_stub;
STUB NtRemoveIoCompletion_stub;
STUB NtSetIoCompletion_stub;
STUB NtCompressKey_stub;
STUB NtCompactKeys_stub;
STUB NtDeleteKey_stub;
STUB NtDeleteValueKey_stub;
STUB NtEnumerateKey_stub;
STUB NtFlushKey_stub;
STUB NtLoadKey_stub;
STUB NtNotifyChangeKey_stub;
STUB NtQueryMultipleValueKey_stub;
STUB NtReplaceKey_stub;
STUB NtRestoreKey_stub;
STUB NtSaveKey_stub;
STUB NtSetInformationKey_stub;
STUB NtUnloadKey_stub;
STUB RtlFormatCurrentUserKeyPath_stub;
STUB NtCreateMutant_stub;
STUB NtOpenMutant_stub;
STUB NtQueryMutant_stub;
STUB NtReleaseMutant_stub;
STUB NtImpersonateClientOfPort_stub;
STUB NtQueryInformationPort_stub;
STUB NtReadRequestData_stub;
STUB NtRegisterThreadTerminatePort_stub;
STUB NtReplyPort_stub;
STUB NtReplyWaitReceivePort_stub;
STUB NtReplyWaitReplyPort_stub;
STUB NtRequestPort_stub;
STUB NtRequestWaitReplyPort_stub;
STUB NtWriteRequestData_stub;
STUB NtCreateProcess_stub;
STUB NtFlushInstructionCache_stub;
STUB NtOpenProcess_stub;
STUB NtTerminateProcess_stub;
STUB RtlCreateUserProcess_stub;
STUB NtExtendSection_stub;
STUB NtOpenSection_stub;
STUB NtQuerySection_stub;
STUB NtCreateSemaphore_stub;
STUB NtOpenSemaphore_stub;
STUB NtQuerySemaphore_stub;
STUB NtReleaseSemaphore_stub;
STUB NtCreateSymbolicLinkObject_stub;
STUB NtOpenSymbolicLinkObject_stub;
STUB NtQuerySymbolicLinkObject_stub;
STUB NtAlertResumeThread_stub;
STUB NtCreateThread_stub;
STUB NtGetContextThread_stub;
STUB NtImpersonateThread_stub;
STUB NtOpenThread_stub;
STUB NtResumeThread_stub;
STUB NtSetContextThread_stub;
STUB NtSetInformationThread_stub;
STUB NtSuspendThread_stub;
STUB NtTerminateThread_stub;
STUB NtContinue_stub;
STUB NtDelayExecution_stub;
STUB NtYieldExecution_stub;
STUB NtCancelTimer_stub;
STUB NtCreateTimer_stub;
STUB NtOpenTimer_stub;
STUB NtQueryTimer_stub;
STUB NtSetTimer_stub;
STUB NtAdjustGroupsToken_stub;
STUB NtCreateToken_stub;
STUB NtSetInformationToken_stub;
STUB NtAccessCheckAndAuditAlarm_stub;
STUB NtCloseObjectAuditAlarm_stub;
STUB NtDeleteObjectAuditAlarm_stub;
STUB NtOpenObjectAuditAlarm_stub;
STUB NtPrivilegedServiceAuditAlarm_stub;
STUB NtPrivilegeObjectAuditAlarm_stub;
STUB NtAllocateLocallyUniqueId_stub;
STUB NtAllocateUuids_stub;
STUB NtPrivilegeCheck_stub;
STUB NtQuerySecurityObject_stub;
STUB NtSetSecurityObject_stub;
STUB NtSetSystemInformation_stub;
STUB NtGetTickCount_stub;
STUB NtQueryTimerResolution_stub;
STUB NtSetSystemTime_stub;
STUB NtSetTimerResolution_stub;
STUB RtlTimeFieldsToTime_stub;
STUB RtlTimeToTimeFields_stub;

// ntdll\_redirects.c
FWDPROC NtAccessCheck_fwd;
FWDPROC NtAdjustPrivilegesToken_fwd;
FWDPROC NtDuplicateToken_fwd;
FWDPROC NtOpenProcessToken_fwd;
FWDPROC NtOpenThreadToken_fwd;
FWDPROC NtQueryInformationToken_fwd;
FWDPROC RtlAddAccessAllowedAce_fwd;
FWDPROC RtlAllocateAndInitializeSid_fwd;
FWDPROC RtlDeleteAce_fwd;
FWDPROC RtlEqualPrefixSid_fwd;
FWDPROC RtlEqualSid_fwd;
FWDPROC RtlGetAce_fwd;
FWDPROC RtlGetControlSecurityDescriptor_fwd;
FWDPROC RtlGetDaclSecurityDescriptor_fwd;
FWDPROC RtlGetGroupSecurityDescriptor_fwd;
FWDPROC RtlGetOwnerSecurityDescriptor_fwd;
FWDPROC RtlGetSaclSecurityDescriptor_fwd;
FWDPROC RtlIdentifierAuthoritySid_fwd;
FWDPROC RtlSetDaclSecurityDescriptor_fwd;
FWDPROC RtlSetGroupSecurityDescriptor_fwd;
FWDPROC RtlSetOwnerSecurityDescriptor_fwd;
FWDPROC RtlSubAuthorityCountSid_fwd;
FWDPROC RtlValidSecurityDescriptor_fwd;
FWDPROC RtlValidSid_fwd;

// ntdll\rtl.c
NTSTATUS NTAPI RtlAdjustPrivilege (IN ULONG Privilege, IN BOOLEAN NewValue, IN BOOLEAN ForThread, OUT PBOOLEAN OldValue);
NTSTATUS RtlCopySid (IN ULONG BufferLength, IN PSID Dest, IN PSID Src);
NTSTATUS RtlCreateSecurityDescriptor (IN PSECURITY_DESCRIPTOR SecurityDescriptor, IN ULONG Revision);
ULONG RtlCreateTagHeap (IN HANDLE HeapHandle, IN ULONG Flags, IN PWSTR TagName, IN PWSTR TagSubName);
NTSTATUS RtlCreateUserThread (IN HANDLE ProcessHandle, IN PSECURITY_DESCRIPTOR SecurityDescriptor OPTIONAL, IN BOOLEAN CreateSuspended, IN ULONG StackZeroBits, IN OUT PULONG StackReserved, IN OUT PULONG StackCommit, IN PVOID StartAddress, IN PVOID StartParameter OPTIONAL, OUT PHANDLE ThreadHandle, OUT PCLIENT_ID ClientID);
NTSTATUS RtlDeleteCriticalSection_new (RTL_CRITICAL_SECTION *crit);
NTSTATUS RtlEnterCriticalSection_new (RTL_CRITICAL_SECTION *crit);
PVOID RtlFreeSid (IN PSID Sid);
VOID RtlInitializeBitMap (OUT PRTL_BITMAP BitMapHeader, IN PULONG BitMapBuffer, IN ULONG SizeOfBitMap);
NTSTATUS RtlInitializeCriticalSection_new (RTL_CRITICAL_SECTION *crit);
NTSTATUS RtlInitializeCriticalSectionAndSpinCount_new (RTL_CRITICAL_SECTION *crit, ULONG spincount);
NTSTATUS RtlInitializeCriticalSectionEx_new (RTL_CRITICAL_SECTION *crit, ULONG spincount, ULONG flags);
NTSTATUS RtlInitializeSid (IN PSID Sid, IN PSID_IDENTIFIER_AUTHORITY IdentifierAuthority, IN UCHAR SubAuthorityCount);
NTSTATUS RtlLeaveCriticalSection_new (RTL_CRITICAL_SECTION *crit);
ULONG RtlLengthRequiredSid (IN ULONG SubAuthorityCount);
ULONG RtlLengthSid (IN PSID Sid);
VOID RtlRaiseStatus (IN NTSTATUS Status);
PULONG RtlSubAuthoritySid (IN PSID Sid, IN ULONG SubAuthority);
NTSTATUS RtlSystemTimeToLocalTime (IN PLARGE_INTEGER SystemTime, OUT PLARGE_INTEGER LocalTime);
NTSTATUS RtlTryEnterCriticalSection_new (RTL_CRITICAL_SECTION *crit);
BOOL NTAPI RtlTimeToSecondsSince1970_new (IN PLARGE_INTEGER pliTime, OUT PULONG pSecondsSince1970);
BOOL NTAPI RtlTimeToSecondsSince1980_new (IN PLARGE_INTEGER pliTime, OUT PULONG pSecondsSince1980);
VOID NTAPI RtlSecondsSince1970ToTime_new (IN ULONG uSecondsSince1970, OUT PLARGE_INTEGER pliTime);
VOID NTAPI RtlSecondsSince1980ToTime_new (IN ULONG uSecondsSince1980, OUT PLARGE_INTEGER pliTime);
LONGLONG WINAPI RtlInterlockedCompareExchange64_new (LONGLONG *dest, LONGLONG xchg, LONGLONG comp);

#define ntdll_ordinal_apis NULL
/*** AUTOGENERATED APILIST DECLARATIONS END ***/

#endif
